
// Internal node for the PRQuadTree
public class PRQuadTreeNodeInternal implements PRQuadTreeNode {
	// Node in each quadrant
	private PRQuadTreeNode NW;	
	private PRQuadTreeNode NE;
	private PRQuadTreeNode SW;
	private PRQuadTreeNode SE;
	private PRQuadTreeNodeFlyweight flyweight;	// Flyweight
	
	// Constructor to initialize the node with flyweights
	public PRQuadTreeNodeInternal(PRQuadTreeNodeFlyweight flyweight) {
		// Initialize all subnodes with the flyweight
		NW = NE = SW = SE = flyweight;
		this.flyweight = flyweight;
	}
	
	// Queries if all subnodes are flyweights
	public boolean isEmpty() {
		return (NW == flyweight)&&(NE == flyweight)&&
				(SW == flyweight)&&(SE == flyweight);
	}
	
	// Test if node contains other internal nodes
	public boolean containsAllLeavesOrFlyweight() {
		// Queries if all subnodes are either leaves or flyweights
		return (NW instanceof PRQuadTreeNodeLeaf || NW instanceof PRQuadTreeNodeFlyweight)&&
				(NE instanceof PRQuadTreeNodeLeaf || NE instanceof PRQuadTreeNodeFlyweight)&&
				(SW instanceof PRQuadTreeNodeLeaf || SW instanceof PRQuadTreeNodeFlyweight)&&
				(SE instanceof PRQuadTreeNodeLeaf || SE instanceof PRQuadTreeNodeFlyweight);
	}
	
	// Returns the number of all records in all subleaves
	public int countOfAllLeafNodes() {
		int ret = 0;
		if (NW instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) NW).getCount();
		if (NE instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) NE).getCount();
		if (SW instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) SW).getCount();
		if (SE instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) SE).getCount();
		return ret;
	}
	
	// Returns the number of records in a node if it is a leaf node
	public int countOfLeafNode(PRQuadTreeNode node) {
		if (node instanceof PRQuadTreeNodeLeaf)
			return ((PRQuadTreeNodeLeaf) node).getCount();
		else
			return 0;
	}
	
	// Encapsulation functions
	public PRQuadTreeNode getNW() {
		return NW;
	}
	public void setNW(PRQuadTreeNode nW) {
		NW = nW;
	}
	public PRQuadTreeNode getNE() {
		return NE;
	}
	public void setNE(PRQuadTreeNode nE) {
		NE = nE;
	}
	public PRQuadTreeNode getSW() {
		return SW;
	}
	public void setSW(PRQuadTreeNode sW) {
		SW = sW;
	}
	public PRQuadTreeNode getSE() {
		return SE;
	}
	public void setSE(PRQuadTreeNode sE) {
		SE = sE;
	}
}
